/*************************************************************************
 *    CompuCell - A software framework for multimodel simulations of     *
 * biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
 *                             Indiana                                   *
 *                                                                       *
 * This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
 *  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
 *  CompuCell GNU General Public License RIDER you can redistribute it   *
 * and/or modify it under the terms of the GNU General Public License as *
 *  published by the Free Software Foundation; either version 2 of the   *
 *         License, or (at your option) any later version.               *
 *                                                                       *
 * This program is distributed in the hope that it will be useful, but   *
 *      WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *             General Public License for more details.                  *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *     along with this program; if not, write to the Free Software       *
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *************************************************************************/

#ifndef CLUSTERDATATRACKERPLUGIN_H
#define CLUSTERDATATRACKERPLUGIN_H

#include <XMLUtils/CC3DXMLElement.h>
#include <CompuCell3D/Plugin.h>
#include <CompuCell3D/Potts3D/Stepper.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Potts3D/Cell.h>
#include <PublicUtilities/ParallelUtilsOpenMP.h>
#include <CompuCell3D/Automaton/Automaton.h>
#include <CompuCell3D/plugins/VolumeTracker/VolumeTrackerPlugin.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <BasicUtils/BasicClassAccessor.h>
//#include "/ufs/boas/svn/cc3d_cwi-3.6.1/DeveloperZone/DZ_MP/MembranePolarizationSteppable/MembranePolarizationSteppable.h"
#include "../MembranePolarizationFluidSteppable/MembranePolarizationFluidSteppable.h"
#include <CompuCell3D/plugins/NeighborTracker/NeighborTracker.h>
#include <CompuCell3D/plugins/NeighborTracker/NeighborTrackerPlugin.h>

#include <CompuCell3D/Field3D/Field3D.h>


#include <vector>


class CC3DXMLElement;
template <typename Y> class BasicClassAccessor;  
template <class T> class WatchableField3D; 
template <class T> class Field3D;
namespace CompuCell3D {
  class Potts3D;
  class CellG;
  class Simulator;
  class MembranePolarizationFluidSteppable;
  class Automaton;
  class VolumeTrackerPlugin;
  class CellInventory; 
  //class NeighborTrackerPlugin;


  class ClusterDataTrackerPlugin : public Plugin, public EnergyFunction, public CellGChangeWatcher, public Stepper 
  {
    Automaton *automaton;
	Potts3D *potts;
	Simulator *sim;
	ParallelUtilsOpenMP *pUtils;
	ParallelUtilsOpenMP::OpenMPLock_t *lockPtr;
  	CC3DXMLElement *xmlData;  
//	std::vector<CellG *> deadCellVec; 
    CellInventory *cellInventoryPtr;
    MembranePolarizationFluidSteppable *MPS;
    VolumeTrackerPlugin *VTP;
    CellG *deadCellG;
    WatchableField3D<CellG *> *fieldG;
      BasicRandomNumberGenerator * rand; 
      
  public:
    //Field3DImpl<float>* getCCFieldByName(std::string _fieldName);     
    Field3D<float> *Ffibrin;
    Field3D<float> *FPLSfibrin;
    Field3D<float> *FPLGfibrin;
  
     // NeighborTrackerPlugin *nTrackerPlugin;
    //BasicClassAccessor<NeighborTracker> * neighborTrackerAccessorPtr;
  
        double initialCellTargetVolume;
        double initialTotalTargetVolume;
        double clusterTargetVolume;
        double clusterLambdaVolume;
        double clusterIdFluid;
        double fluidLambdaVolume; //lambda fluid volume  
        double lumenFluidLambdaVolume;  
        long int clusterIdFibrin; 
        double fibrinFlipPenalty; 
        double probabilityMedium;        

      typedef struct
          {
            CellG* basolatCompartment;
            CellG* apicalCompartment;
            CellG* cytoplasmCompartment;
            bool EC; //true if it is an EC, false for eg ECM
            bool tip; //true if tipcell
            bool pericyte; //true if pericyte
            double clusterVolume;	// volume of total cluster
            double clusterTargetVolume;	// targetvolume of cluster
            double clusterLambdaVolume;	// lambda cluster volume
            std::map<long int,CellG*> cellsInCluster;//list of the cellids present in this cluster  
            double uPARconcentration; // total concentration of uPAR cell membrane
            double uPARactConcentration; // total concentration of uPAR cell membrane
            std::set<PixelTrackerData> boundaryTrackerList; //list of membrane pixels of cluster
            std::set<PixelTrackerData> staticBoundaryTrackerListAtMCS; //list of membrane pixels of cluster
            
            double uPARConcentration;
            double notchConcentration;
            double deltaConcentration;
            double VEGFR2Concentration;
            double reporterConcentration;
            double VEGFreporterConcentration;
          }clusterData;
          
        map<long int, clusterData > clusterDataMap;

        void insertCellInCluster(CellG* cell)
          {
          cerr<<"insert cell id="<<  cell->clusterId<<endl;  
              cerr<<"insert cell clv voor="<< clusterLambdaVolume<<endl; 
        if ( clusterDataMap.find(cell->clusterId) == clusterDataMap.end() )
            { 

            //cerr<<"CDT init2"<<endl;
            clusterData clusterDataCell;  
            clusterDataCell.uPARConcentration=0.0;
            clusterDataCell.notchConcentration=0.0;
            clusterDataCell.deltaConcentration=0.0;  
            clusterDataCell.VEGFR2Concentration=0.0;  
            clusterDataCell.reporterConcentration=0.0; 
            clusterDataCell.VEGFreporterConcentration=0.0; 
            map<long int,CellG*> cellsInClusterList;
            cellsInClusterList[cell->id] = cell;
            if ((cell->type==automaton->getTypeId("BM-3")))
                {
                initialTotalTargetVolume+=cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=NULL;  
                clusterDataCell.EC=false;        
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=cell->volume;
                clusterDataCell.clusterLambdaVolume=0.0;
                clusterDataCell.cellsInCluster=cellsInClusterList;
                clusterDataCell.uPARconcentration=0.0;
                clusterDataCell.uPARactConcentration=0.0;
                //cerr<<"##########2clusterCellBM"<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                }     
                
            if ((cell->type==automaton->getTypeId("fibrin")))
                {
                clusterIdFibrin=cell->clusterId; 
                initialTotalTargetVolume+=cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=NULL;  
                clusterDataCell.EC=false; 
                clusterDataCell.tip=false; 
                clusterDataCell.pericyte=false;       
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=cell->volume;
                clusterDataCell.clusterLambdaVolume=0;
                clusterDataCell.cellsInCluster=cellsInClusterList;
                //clusterDataCell.uPARconcentration=0.0;
                //clusterDataCell.uPARactConcentration=0.0;
                }                    
             else if ((cell->type==automaton->getTypeId("fluid")))
                 {
                initialTotalTargetVolume+=cell->volume;
                clusterIdFluid=cell->clusterId;                
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=cell;  
                clusterDataCell.EC=false; 
               clusterDataCell.tip=false; 
                clusterDataCell.pericyte=false;      
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=cell->volume;
                clusterDataCell.clusterLambdaVolume=fluidLambdaVolume;
                clusterDataCell.cellsInCluster=cellsInClusterList;  
                //clusterDataCell.uPARconcentration=0.0; 
                //clusterDataCell.uPARactConcentration=0.0; 
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                }   
            else if ((cell->type==automaton->getTypeId("lumenfluid")))
                 {                
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=cell;  
                clusterDataCell.EC=false;  
               clusterDataCell.tip=false; 
                clusterDataCell.pericyte=false;      
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=0.0;
                clusterDataCell.clusterLambdaVolume=lumenFluidLambdaVolume;
                clusterDataCell.cellsInCluster=cellsInClusterList;  
                //clusterDataCell.uPARconcentration=0.0; 
                //clusterDataCell.uPARactConcentration=0.0;
                 
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                }                   
                
            else if (cell->type==automaton->getTypeId("cell"))
                {  
                cerr<<"2 insert cell id="<<  cell->clusterId<<endl;  
                initialTotalTargetVolume+=cell->volume;
                if (!initialCellTargetVolume)
                    initialCellTargetVolume= cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=cell;  
                clusterDataCell.EC=true;
                clusterDataCell.tip=false;
                clusterDataCell.pericyte=false; 
                clusterDataCell.clusterVolume=cell->volume;
                if (clusterTargetVolume)
                    {
                    cerr<<"clusterTargetVolume="<<clusterTargetVolume<<endl;
                    clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                    }
                else
                    clusterDataCell.clusterTargetVolume=cell->volume; 
                //clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                clusterDataCell.clusterLambdaVolume=clusterLambdaVolume;
                cerr<<"2 insert cell cvl="<<clusterLambdaVolume<<endl; 
                clusterDataCell.cellsInCluster=cellsInClusterList;
                //clusterDataCell.uPARconcentration=0.0;
                //clusterDataCell.uPARactConcentration=0.0;
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                } 
               
            else if (cell->type==automaton->getTypeId("apical"))
                {  
                cerr<<"2 insert cell id="<<  cell->clusterId<<endl;  
                initialTotalTargetVolume+=cell->volume;
                if (!initialCellTargetVolume)
                    initialCellTargetVolume= cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=cell;
                clusterDataCell.cytoplasmCompartment=NULL;  
                clusterDataCell.EC=true;
                clusterDataCell.tip=false;
                clusterDataCell.pericyte=false; 
                clusterDataCell.clusterVolume=cell->volume;
                if (clusterTargetVolume)
                    {
                    cerr<<"clusterTargetVolume="<<clusterTargetVolume<<endl;
                    clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                    }
                else
                    clusterDataCell.clusterTargetVolume=cell->volume; 
                //clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                clusterDataCell.clusterLambdaVolume=clusterLambdaVolume;
                cerr<<"2 insert cell cvl="<<clusterLambdaVolume<<endl; 
                clusterDataCell.cellsInCluster=cellsInClusterList;
                //clusterDataCell.uPARconcentration=0.0;
                //clusterDataCell.uPARactConcentration=0.0;
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                }   
                
      
                
            else if (cell->type==automaton->getTypeId("pericyte"))
                {  
                //cerr<<"CDT init4"<<endl;
                initialTotalTargetVolume+=cell->volume;
                if (!initialCellTargetVolume)
                    initialCellTargetVolume= cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=cell;  
                clusterDataCell.EC=true; 
                clusterDataCell.tip=false; 
                clusterDataCell.pericyte=true; 
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=cell->volume;
                //clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                clusterDataCell.clusterLambdaVolume=clusterLambdaVolume;
                clusterDataCell.cellsInCluster=cellsInClusterList;
                //clusterDataCell.uPARconcentration=0.0;
                //clusterDataCell.uPARactConcentration=0.0;
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                } 
            else if (cell->type==automaton->getTypeId("border"))
                {  
                //cerr<<"CDT init4"<<endl;
                initialTotalTargetVolume+=cell->volume;
                if (!initialCellTargetVolume)
                    initialCellTargetVolume= cell->volume;
                clusterDataCell.basolatCompartment=NULL;
                clusterDataCell.apicalCompartment=NULL;
                clusterDataCell.cytoplasmCompartment=cell;  
                clusterDataCell.EC=false; 
                clusterDataCell.tip=false; 
                clusterDataCell.pericyte=false; 
                clusterDataCell.clusterVolume=cell->volume;
                clusterDataCell.clusterTargetVolume=cell->volume;
                //clusterDataCell.clusterTargetVolume=clusterTargetVolume;
                clusterDataCell.clusterLambdaVolume=clusterLambdaVolume;
                clusterDataCell.cellsInCluster=cellsInClusterList;
                //clusterDataCell.uPARconcentration=0.0;
                //clusterDataCell.uPARactConcentration=0.0;
                //cerr<<"##########2clusterCellV="<<clusterDataCell.clusterVolume<<" targetV "<<clusterDataCell.clusterTargetVolume<<endl;
                } 
            clusterDataMap[cell->clusterId] = clusterDataCell;
            //clusterDataMap.insert( std::make_pair(cell->clusterId, clusterDataCell) pair < long int ,clusterData>((cell->clusterId),clusterDataCell));
            } 
        else{
            clusterData& cd=(clusterDataMap.find(cell->clusterId)->second);
            (cd.cellsInCluster)[cell->id] = cell;
            cd.clusterVolume+=(cell->volume);
            if ((!(cd.cytoplasmCompartment)) && (cell->type==automaton->getTypeId("cell")))
                {
                cd.cytoplasmCompartment=cell;
                }
            else if ((!(cd.apicalCompartment)) && (cell->type==automaton->getTypeId("apical")))
                {
                cd.apicalCompartment=cell;
                }
            else if ((!(cd.basolatCompartment)) && (cell->type==automaton->getTypeId("basolat")))
                {
                cd.basolatCompartment=cell;
                }           
                    
            //cerr<<"CDT init8"<<endl; 
            }
        //potts->runSteppers();
          }
          
        void deleteCellInCluster(CellG* deleteCell)
          {  
              //cerr<<"CDT init8"<<endl; 
            long int clusterId=deleteCell->clusterId;
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {   
                clusterData& cd=(clusterDataMap.find(clusterId)->second);   
                map<long int,CellG*>& cellsInCluster = cd.cellsInCluster;
                if (cellsInCluster.find(deleteCell->id)!=cellsInCluster.end())
                    {
                    cellsInCluster.erase(deleteCell->id);
                    //(clusterDataMap.find(clusterId)->second).cellsInCluster=cellsInCluster;

                    if (cd.basolatCompartment == deleteCell)
                        {
                        cd.basolatCompartment=NULL;
                        }  
                    else if (cd.apicalCompartment == deleteCell)
                        {
                        cd.apicalCompartment=NULL;
                        }
                    else if (cd.cytoplasmCompartment == deleteCell)
                        {
                        cd.cytoplasmCompartment=NULL;
                        }  
                    if (!cellsInCluster.size())
                        {
                        clusterDataMap.erase(clusterId);
                        }
                    }
                }
            }

//////////Delta-Notch 
         double getuPARConcentration(long int clusterId)
            {
            double uPARC=0.0;
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                uPARC=(clusterDataMap.find(clusterId)->second).uPARConcentration;               
                }
            return uPARC;
            }
            
        double getNotchConcentration(long int clusterId)
            {
            double notchC=0.0;
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                notchC=(clusterDataMap.find(clusterId)->second).notchConcentration;               
                }
            return notchC;
            }
            
            
        double getDeltaConcentration(long int clusterId) 
            {
            double deltaC=0.0;
                if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                    {             
                    deltaC=(clusterDataMap.find(clusterId)->second).deltaConcentration;               
                    }
                return deltaC;
            } 
        
        double getReporterConcentration(long int clusterId)
            {
            double reporterC=0.0;
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                reporterC=(clusterDataMap.find(clusterId)->second).reporterConcentration;               
                }
            return reporterC;
            }
            
        double getVEGFreporterConcentration(long int clusterId)
            {
            double reporterVEGFC=0.0;
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                reporterVEGFC=(clusterDataMap.find(clusterId)->second).VEGFreporterConcentration;               
                }
            return reporterVEGFC;
            }
            
        double getVEGFR2Concentration(long int clusterId) 
            {
            double VEGFR2conc=0.0;
                if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                    {             
                    VEGFR2conc=(clusterDataMap.find(clusterId)->second).VEGFR2Concentration;               
                    }
                return VEGFR2conc;
            } 
            
        void setuPARConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).uPARConcentration=concentration;
                }
            }   
              
        void setNotchConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).notchConcentration=concentration;
                }
            }
            
            
        void setDeltaConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).deltaConcentration=concentration;
                }
            }
            
        void setReporterConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).reporterConcentration=concentration;
                }
            }    
            
        void setVEGFreporterConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).VEGFreporterConcentration=concentration;
                }
            } 
            
        void setVEGFR2Concentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).VEGFR2Concentration=concentration;
                }
            }
        
        void adduPARConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).uPARConcentration += concentration; 
                }
            }
            
        void addNotchConcentration(long int clusterId, double concentration)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).notchConcentration += concentration; 
                }
            }
            
            
        void addDeltaConcentration(long int clusterId, double concentration) 
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).deltaConcentration += concentration;   
                }
            } 
            
        void addReporterConcentration(long int clusterId, double concentration) 
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).reporterConcentration += concentration;   
                }
            } 
            
        void addVEGFreporterConcentration(long int clusterId, double concentration) 
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).VEGFreporterConcentration += concentration;   
                }
            } 
            
        void addVEGFR2Concentration(long int clusterId, double concentration) 
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).VEGFR2Concentration += concentration;               
                }
            } 
            
            
            
            
            
/////////Boundary            
        void setStaticBoundaryTrackerListAtMCS(long int clusterId, set<PixelTrackerData> membranePixelSet)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).staticBoundaryTrackerListAtMCS=membranePixelSet;
                }
            }
                    
        set<PixelTrackerData> getStaticBoundaryTrackerListAtMCS(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                set<PixelTrackerData> membranePixelSet=(clusterDataMap.find(clusterId)->second).staticBoundaryTrackerListAtMCS;
                return membranePixelSet;
                }
            }
            
            
                       
        
        void setBoundaryTrackerList(long int clusterId, set<PixelTrackerData> membranePixelSet)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).boundaryTrackerList=membranePixelSet;
                }
            }
                    
        set<PixelTrackerData> getBoundaryTrackerList(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                set<PixelTrackerData> membranePixelSet=(clusterDataMap.find(clusterId)->second).boundaryTrackerList;
                return membranePixelSet;
                }
            else
                {
                set<PixelTrackerData> membranePixelSet;
                return membranePixelSet;
                
                }
            }

            
        void insertMembranePixelList(long int clusterId,PixelTrackerData pixel)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                set<PixelTrackerData> boundryPixelsList = (clusterDataMap.find(clusterId)->second).boundaryTrackerList;
                boundryPixelsList.insert(pixel);
                (clusterDataMap.find(clusterId)->second).boundaryTrackerList=boundryPixelsList;
                }
            }
            
        void deleteMembranePixelList(long int clusterId,PixelTrackerData pixel)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                set<PixelTrackerData> boundryPixelsList = (clusterDataMap.find(clusterId)->second).boundaryTrackerList;
                boundryPixelsList.erase(pixel);
                (clusterDataMap.find(clusterId)->second).boundaryTrackerList=boundryPixelsList;
                }
            }
//////////////////////// fibrin degradation
 
 
         long int getFibrinClusterId()
            {  
            long int fibrinClusterId= clusterIdFibrin;   
            return fibrinClusterId; 
            }
            
        double getUPARconc(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                double uPARconcentration= (clusterDataMap.find(clusterId)->second).uPARconcentration;
                return uPARconcentration;
                }
            }           

        void setUPARconc(long int clusterId, double newValue)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).uPARconcentration=newValue;               
                }
            } 
           
        double getUPARactConc(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                double uPARactConcentration= (clusterDataMap.find(clusterId)->second).uPARactConcentration;
                return uPARactConcentration;
                }
            }           

        void setUPARactConc(long int clusterId, double newValue)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).uPARactConcentration=newValue;               
                }
            }
  
  
  ///////////////// get cells          
        bool getIfEC(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                bool EC = (clusterDataMap.find(clusterId)->second).EC;
                return EC;
                }
            }  
           
        bool getIfTip(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                bool EC = (clusterDataMap.find(clusterId)->second).tip;
                return EC;
                }
            }    
            
        bool getIfPericyte(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                bool pericyte = (clusterDataMap.find(clusterId)->second).pericyte;
                return pericyte;
                }
            }  
     
       std::set<long int> getClusterIdsList()
            {
            set<long int> clusterIdsList;
            map<long int,clusterData> ::iterator clusterIt;
            for ( clusterIt=clusterDataMap.begin() ; clusterIt != clusterDataMap.end(); ++clusterIt )
                {
                long clusterId= (*clusterIt).first; //key
                
                clusterIdsList.insert(clusterId);
                }
            return clusterIdsList;
            }   
            
        std::map<long int,CellG*> getCellsInClusterList(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {
                map<long int,CellG*> cellsInCluster = (clusterDataMap.find(clusterId)->second).cellsInCluster;
                return cellsInCluster;
                }
            }
      
            
        CellG* getFluidCell()
            {
            CellG* fluidCell = NULL;        
            if (clusterDataMap.find(clusterIdFluid)!=clusterDataMap.end())
                {
                fluidCell= (clusterDataMap.find(clusterIdFluid)->second).cytoplasmCompartment;
                //cerr<<"##########CTDprint fluidcell="<<fluidCell<<" cellid "<<fluidCell->id<<" volume "<<fluidCell->volume<<endl;   
                }
            return fluidCell;           
            } 
            
        CellG* getCytoplasmCell(long int clusterId)
            {
            CellG* cytoplasmCell = NULL;            
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {
                cytoplasmCell = (clusterDataMap.find(clusterId)->second).cytoplasmCompartment;
                }
            return cytoplasmCell;            
            }
            
        CellG* getApicalCell(long int clusterId)
            {
            CellG* apicalCell = NULL; 
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {
                apicalCell = (clusterDataMap.find(clusterId)->second).apicalCompartment;
                }
            return apicalCell;
            }
            
        CellG* getBasolateralCell(long int clusterId)
            {
            CellG* basolatCell = NULL; 
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {
                basolatCell = (clusterDataMap.find(clusterId)->second).basolatCompartment;
                }
            return basolatCell;
            }
 
//////////////volumes
        double getClusterVolume(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                double clusterVolume = (clusterDataMap.find(clusterId)->second).clusterVolume;
                return clusterVolume;
                }
            }
            
        double getClusterTargetVolume(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                double clusterTargetVolume = (clusterDataMap.find(clusterId)->second).clusterTargetVolume;
                return clusterTargetVolume;
                }
            }   
           

            
        double getClusterLambdaVolume(long int clusterId)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                double clusterLambdaVolume = (clusterDataMap.find(clusterId)->second).clusterLambdaVolume;
                return clusterLambdaVolume;
                }
            }   
        double setClusterLambdaVolume(long int clusterId, double lv)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).clusterLambdaVolume=lv;  
                }
            }   
            
        void adjustClusterTargetVolumeAfterVesicleAddition(CellG* newCell)
            {
            if ( clusterDataMap.find(newCell->clusterId) != clusterDataMap.end() )
                {
                (clusterDataMap.find(newCell->clusterId)->second).clusterTargetVolume+=1;
//                     if ((newCell->type==automaton->getTypeId("vesicle"))||(newCell->type==automaton->getTypeId("vacuole")))                    
//                         newCell->targetVolume+=1;
                }                    
           CellG* fluidCell=getFluidCell();
           if (fluidCell)
               (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume-=1; 
            }
            
        void adjustClusterTargetVolumeAfterVesicleSubstraction(CellG* oldCell)
            {
            if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )
                {
                (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=1;
//                     if ((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole")))
//                         oldCell->targetVolume-=1;  
                }                    
            CellG* fluidCell=getFluidCell();
            if (fluidCell)
                {     
                (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume+=1;            
                } 
            }
            
        void addClusterTargetVolume(long int clusterId, double add)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).clusterTargetVolume+=add;               
                }
            }           

        void addClusterVolume(long int clusterId, double add)
            {
            if (clusterDataMap.find(clusterId)!=clusterDataMap.end())
                {             
                (clusterDataMap.find(clusterId)->second).clusterVolume+=add;               
                }
            } 
            
    ///////////////print           
        void printClusterIdCells()
            {
            map<long int,clusterData >::iterator clusterIt;
            for ( clusterIt=clusterDataMap.begin() ; clusterIt != clusterDataMap.end(); ++clusterIt )
                {
                cerr<<"##########CTD printclusterID="<<(*clusterIt).first<<" vol="<< getClusterVolume((*clusterIt).first)<<" targetVol="<<getClusterTargetVolume((*clusterIt).first)<<endl;
                    
                map<long int,CellG*> cellsInCluster = (clusterDataMap.find((*clusterIt).first)->second).cellsInCluster;
                map<long int,CellG*> ::iterator cellInClusterIt;
                for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
                    {
                    long int keyId=(*cellInClusterIt).first;
                    CellG *cell=(*cellInClusterIt).second;
                    //cellCount+=1;
                    cerr<<"##########CTDprint cell="<<cell<<" cellid "<<cell->id<<" lambdavolume="<<cell->lambdaVolume<<" targetvolume "<<cell->targetVolume<<" Volume= "<<cell->volume<<endl;
                    }
                }
            }
            
        void printTotalTargetVolume()
            {
            cerr<<"########## PRINT VOLUMES AND TV="<<endl;
            double totalTargetVolume=0.0;
            double lftotalTargetVolume=0.0;
            map<long int,clusterData >::iterator clusterIt;
            for ( clusterIt=clusterDataMap.begin() ; clusterIt != clusterDataMap.end(); ++clusterIt )
                {
                totalTargetVolume+=getClusterTargetVolume((*clusterIt).first); 
                cerr<<"##########CTD printclusterID="<<(*clusterIt).first<<" vol="<< getClusterVolume((*clusterIt).first)<<" targetVol="<<getClusterTargetVolume((*clusterIt).first)<<endl;   
                }
//             CellInventory::cellInventoryIterator cInvIttr;
//             //cerr<<"vacuole3- celllist"<<endl;
//             for(cInvIttr=cellInventoryPtr->cellInventoryBegin() ; cInvIttr !=cellInventoryPtr->cellInventoryEnd() ;++cInvIttr )
//                 {                       
//                 CellG * cell=NULL;
//                 cell=cellInventoryPtr->getCell(cInvIttr);            
                
//                 if (cell->volume && (cell->type==automaton->getTypeId("lumenfluid")))
//                    { 
//                    totalTargetVolume+=cell->targetVolume;
//                    cerr<<"##########lumenfl cellId=" <<cell->id<<" vol= "<< cell->volume<<" TargetVolume= "<<cell->targetVolume<<" Volume= "<<cell->volume<<endl;  
//                    lftotalTargetVolume+=cell->volume;                    
//                    }
//                 }
//             cerr<<"##########CTDprint lumenfl TargetVolume= "<<lftotalTargetVolume<<endl;   
            cerr<<"##########CTDprint totaltargetVolume= "<<totalTargetVolume<<endl;          
            }
            
        void printTotalCellVolume()
            {
            cerr<<"########## PRINT VOLUMES AND TV of cell="<<endl;
            map<long int,clusterData >::iterator clusterIt;
            for ( clusterIt=clusterDataMap.begin() ; clusterIt != clusterDataMap.end(); ++clusterIt )
                {
   //fluidLambdaVolume
                map<long int,CellG*> cellsInCluster=getCellsInClusterList((*clusterIt).first);
                map<long int,CellG*> ::iterator cellInClusterIt;    
                double totalVesVac=0.0;
                double totalTVVesVac=0.0;    
                for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
                    {
                    long int keyId=(*cellInClusterIt).first;
                    CellG *cell=(*cellInClusterIt).second; 
                        
                    //cellCount+=1;
                    //cerr<<"##########CTDprint cell="<<cell<<" cellid "<<cell->id<<" volume "<<cell->volume<<endl;
                    
                    if ((cell->type==automaton->getTypeId("vesicle"))||(cell->type==automaton->getTypeId("vacuole")))   
                       {  
                        totalVesVac+=cell->volume;  
                        totalTVVesVac+=cell->targetVolume;     
                       }
                   }    
                cerr<<"##########CTD printclusterID="<<(*clusterIt).first<<"vol="<< getClusterVolume((*clusterIt).first)<<" targetVol="<<getClusterTargetVolume((*clusterIt).first)<<" real vol="<<getClusterVolume((*clusterIt).first)-totalVesVac<<" real TV vol="<<getClusterTargetVolume((*clusterIt).first)-totalTVVesVac<<endl;   
                }        
            }    
            
        void printTotalTargetVolumeError()
            {
            //cerr<<"########## TotalTargetVolume ERRRRROOORRRRRRR="<<endl;
            double totalTargetVolume=0.0;
            double lftotalTargetVolume=0.0;
            double totalVolume=0.0;
            map<long int,clusterData >::iterator clusterIt;
            for ( clusterIt=clusterDataMap.begin() ; clusterIt != clusterDataMap.end(); ++clusterIt )
                {
                double clusterTV=getClusterTargetVolume((*clusterIt).first);
                totalTargetVolume+=clusterTV; 
                totalVolume+=getClusterVolume((*clusterIt).first);
                map<long int,CellG*> cellsInCluster = (clusterDataMap.find((*clusterIt).first)->second).cellsInCluster;
                map<long int,CellG*> ::iterator cellInClusterIt;
                double totalVesVac=0.0;
                if ((clusterDataMap.find((*clusterIt).first)->second).EC)
                    {
                    for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
                        {
                        long int keyId=(*cellInClusterIt).first;
                        CellG *cell=(*cellInClusterIt).second; 
                        //cellCount+=1;
                        //cerr<<"##########CTDprint cell="<<cell<<" cellid "<<cell->id<<" volume "<<cell->volume<<endl;
                        
                        if ((cell->type==automaton->getTypeId("vesicle"))||(cell->type==automaton->getTypeId("vacuole")))   
                           {  
                            totalVesVac+=cell->targetVolume; 
                            if (cell->targetVolume<0)
                                 cerr<<"Error NEGATIVETV!!!!!!!"<<endl;      
                           }
                       }

                    //cerr<<"TV = "<<clusterTV<<" toatalVesVac= "<<totalVesVac<<" initialCellTargetVolume= "<<initialCellTargetVolume<<endl;
                    if  (clusterTV- initialCellTargetVolume- totalVesVac) 
                        {
                        cerr<<"########## TotalTargetVolume ERRRRROOORRRRRRR="<<endl;
                        cerr<<"    error totaltargetVolumeCluster= "<<clusterTV- initialCellTargetVolume- totalVesVac<<" of clusterId "<<(*clusterIt).first<<endl; 
                        }     
                    }
                //cerr<<"##########CTD printclusterID="<<(*clusterIt).first<<" vol="<< getClusterVolume((*clusterIt).first)<<" targetVol="<<getClusterTargetVolume((*clusterIt).first)<<endl;   
                }
//             CellInventory::cellInventoryIterator cInvIttr;
//             //cerr<<"vacuole3- celllist"<<endl;
//             for(cInvIttr=cellInventoryPtr->cellInventoryBegin() ; cInvIttr !=cellInventoryPtr->cellInventoryEnd() ;++cInvIttr )
//                 {                       
//                 CellG * cell=NULL;
//                 cell=cellInventoryPtr->getCell(cInvIttr);            
                
//                 if (cell->volume && (cell->type==automaton->getTypeId("lumenfluid")))
//                    { 
//                    totalTargetVolume+=cell->targetVolume;
//                    //cerr<<"##########lumenfl cellId=" <<cell->id<<" vol= "<< cell->volume<<" TargetVolume= "<<cell->targetVolume<<endl;  
//                    lftotalTargetVolume+=cell->targetVolume;                    
//                    }
//                 }
            //cerr<<"##########CTDprint lumenfl TargetVolume= "<<lftotalTargetVolume<<endl;   
            //cerr<<"##########CTDprint totaltargetVolume= "<<totalTargetVolume<<endl;
            //cerr<<"    initialtotaltargetVolume= "<<initialTotalTargetVolume<<"TTV= "<<totalTargetVolume<<endl;    
            double totalTargetVolumeError=initialTotalTargetVolume-totalTargetVolume;
            cerr<<"########## TotalTargetVolume Simulation ="<<totalTargetVolume<<" totalVolume="<<totalVolume<<endl;
            if (totalTargetVolumeError)
                {
                   
                cerr<<"  ERRRRROOORRRRRRR  error sim totaltargetVolume= "<<totalTargetVolumeError<<endl;   
                }
            }         
            
            
            
	ClusterDataTrackerPlugin();
	virtual ~ClusterDataTrackerPlugin();
	
	// SimObject interface
	virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData);
	virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
	virtual void extraInit(Simulator *simulator);
	// CellChangeWatcher interface
        virtual double changeEnergy(const Point3D &pt, const CellG *newCell,const CellG *oldCell);
	virtual void field3DChange(const Point3D &pt, CellG *newCell, CellG *oldCell);
	
	// Stepper interface
	virtual void step();
	virtual std::string toString();
	virtual std::string steerableName();
  };
};
#endif
